# Apply passive NRDP checks to hosts from passed-in hiera variables.

class twitch_vidops_tools::monitoring (
  $load          = $twitch_vidops_tools::load,
  $mem           = $twitch_vidops_tools::mem,
  $disk          = $twitch_vidops_tools::disk,
  $daemontools   = $twitch_vidops_tools::daemontools,
  $puppet_master = hiera('twitch_puppet::agent::puppet_server', 'video-puppet.prod.puppet.live-video.a2z.com'),
  $puppet_ca     = hiera('twitch_puppet::agent::puppet_ca_server', 'video-puppet-ca.prod.puppet.live-video.a2z.com'),
) inherits twitch_vidops_tools {

  include twitch::packages
  realize(Package['jq'])

  # AWS vs Baremetal checks
  if $::ec2_metadata != undef {
    # AWS only requires single NTP source
    $ntp_min_sources = 1
  }
  else {
    $ntp_min_sources = 2

    unless $::manufacturer == 'Kontron' {
      twitch_servicecheck::passive { 'link_aggregation':
        command  => '/usr/local/monitor_scripts/check_team.py',
        user     => 'nagios',
        interval => 1,
      }
    }
  }

  if $::manufacturer == 'Kontron' {
    twitch_servicecheck::passive { 'disk space':
      command  => '/usr/lib/nagios/plugins/check_disk -w 10% -c 5% -p /',
      interval => 2,
    }
  } else {
    twitch_servicecheck::passive { 'ipmi_sensors':
      command  => '/usr/local/monitor_scripts/check_ipmi_sensor -v --nosel',
      user     => 'nagios',
      interval => 5,
      options  => {
        'use' => 'passive-service-email'
      },
    }
    twitch_servicecheck::passive { 'disk space':
      command  => "/usr/lib/nagios/plugins/check_disk ${disk} -i /srv/node/.* -i /snap",
      interval => 3,
    }
    twitch_servicecheck::passive { 'raid-array':
      command  => '/usr/local/monitor_scripts/check_raid.pl',
      interval => 2,
    }
  }

  # These checks go on *all* video hosts.
  twitch_servicecheck::passive { 'shared-memory':
    command  => '/usr/lib/nagios/plugins/check_disk -w 20% -c 10% -p /run/shm',
    interval => 1,
  }
  twitch_servicecheck::passive { 'ntp':
    command  => "/usr/local/monitor_scripts/check_chrony_health -w '${ntp_min_sources}:' -c '1:'",
    interval => 3,
  }
  twitch_servicecheck::passive { 'load':
    command  => "/usr/lib/nagios/plugins/check_load -r ${load}",
    interval => 1,
  }
  twitch_servicecheck::passive { 'memory':
    command  => "/usr/local/monitor_scripts/check_memswap.pl ${mem}",
    interval => 1,
  }

  twitch_servicecheck::passive { 'daemontools pid':
    command  => "/usr/local/monitor_scripts/check_daemontools ${daemontools}",
    user     => 'nagios',
    interval => 5,
  }

  # These server classes use consul for server-status, so we use a consul-enabled
  # check that only goes warning. (so you know it's safe to enable the server)
  # We're hoping this oddity goes away soon!(tm)
  twitch_servicecheck::passive { 'consul-enabled':
    command => '/usr/local/monitor_scripts/check_consul_enabled.sh -c',
    require => Package['jq'],
    options => {
      'use' => 'passive-service-email'
    },
  }
  twitch_servicecheck::passive { 'check_consul':
    command => "/usr/local/monitor_scripts/check_consul.py ${::fqdn}",
    retry   => 5
  }

}
