# This module installs puppetpaws and a crontab to run it every hour.
# Puppet paws is a wrapper for puppet to help run it consistently.

class twitch_vidops_tools::puppetpaws {

  file { '/var/lib/puppet/puppetpaws.tcl':
    ensure => absent,
  }

  # Randomize the crontab (minute) and run every hour.
  cron::job { 'puppetpaws':
    ensure      => absent,
    command     => 'test -f /etc/profile.d/proxy.sh && . /etc/profile.d/proxy.sh ; /var/lib/puppet/puppetpaws.tcl 2>&1 | logger -p local3.warn -t puppetpaws',
    user        => 'root',
    minute      => fqdn_rand(59,'puppetpaws_minute'),
    require     => File['/var/lib/puppet/puppetpaws.tcl'],
    environment => 'PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/bin',
  }

  cron { 'puppetpaws':
    ensure => 'absent',
    user   => 'root',
  }
}
