#Build the S3 uploader existence
# DO NOT USE THIS FOR VERY LARGE CLUSTERS. 
# Preferably only for FQDN

define twitch_vidops_tools::s3_uploader_cron_resource (
  $ensure                    = present,
  $pre_commands              = 'cd /var/tmp; tar -cf /var/tmp/jtv_logs.tar /var/log/jtv/* --warning=no-file-changed',
  $post_commands             = 'find /var/tmp -iname jtv_logs.tar --exec rm {} \;',
  $hour                      = '12', # The hour at which to run the cron job. Optional; 
  $minute                    = '0', # The minute at which to run the cron job...
  $weekday                   = '*',
  $local_user                = 'root',
  $sandstorm_credentials_key = 'video-ops/s3-uploader/production/aws-creds',
  $aws_s3_bucket             = 's3://vidops-s3-uploader-cron',
  $path_to_upload            = '/var/tmp/',
  $filename_to_upload        = 'jtv_logs.tar',
  $cron_name = regsubst($name, '[ \.:]', '_')
) {
  include twitch_vidops_tools::s3_uploader_crons

  file { "/var/lib/s3_uploader_cron/${cron_name}":
    ensure  => 'directory',
    owner   => $local_user,
    group   => $local_user,
    mode    => '0700',
    require => File['/var/lib/s3_uploader_cron/'],
  }

  file { "/var/lib/s3_uploader_cron/${cron_name}/.aws":
    ensure  => 'directory',
    owner   => $local_user,
    group   => $local_user,
    mode    => '0750',
    require => File["/var/lib/s3_uploader_cron/${cron_name}"],
  }

  #template script - Precommands & post commands are injected into the template itself

  file { "/var/lib/s3_uploader_cron/${cron_name}/${cron_name}_s3_uploader.sh" :
    ensure  => 'present',
    owner   => $local_user,
    group   => $local_user,
    mode    => '0750',
    content => template('twitch_vidops_tools/s3_uploader.sh.erb'),
    require => File["/var/lib/s3_uploader_cron/${cron_name}/"],
  }

  #sandstorm config
  twitch_sandstorm_agent::template { "${cron_name}_s3_uploader_sandstorm":
    destination => "/var/lib/s3_uploader_cron/${cron_name}/.aws/credentials",
    owner       => $local_user,
    group       => $local_user,
    mode        => '0600',
    key         => $sandstorm_credentials_key,
    require     => File["/var/lib/s3_uploader_cron/${cron_name}/.aws"],
  }

  #cron config
  cron::job { "${cron_name}_s3_uploader_cron":
    command     => "test -f /etc/profile.d/proxy.sh && . /etc/profile.d/proxy.sh ; /var/lib/s3_uploader_cron/${name}/${name}_s3_uploader.sh 2>&1 | logger -p local3.warn -t ${cron_name}_s3_uploader_cron",
    user        => $local_user,
    minute      => $minute,
    hour        => $hour,
    weekday     => $weekday,
    require     => File["/var/lib/s3_uploader_cron/${name}/${name}_s3_uploader.sh"],
    environment => 'PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/bin',
  }

}
