#
class twitch_vividcortex (
  $ensure          = $twitch_vividcortex::params::ensure,
  $sandstorm_key   = $twitch_vividcortex::params::sandstorm_key,
  $conf_dir        = $twitch_vividcortex::params::conf_dir,
  $proxy           = $twitch_vividcortex::params::proxy,
  $proxy_port      = $twitch_vividcortex::params::proxy_port,
) inherits twitch_vividcortex::params {

  validate_re($ensure, ['^present$', '^absent$'])
  validate_absolute_path($conf_dir)


  file{ [$conf_dir, '/var/log/vividcortex']:
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file { '/var/lib/vividcortex':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0750',
  }

  file { '/var/lib/vividcortex/install.sh':
    ensure => 'file',
    owner  => 'root',
    group  => 'root',
    mode   => '0544',
    source => "puppet:///modules/${module_name}/install.sh",
  }

  file { '/var/lib/vividcortex/install_auto.sh':
    ensure  => 'file',
    owner   => 'root',
    group   => 'root',
    mode    => '0544',
    content => template("${module_name}/install_auto.sh.erb"),
    require => File['/var/lib/vividcortex/install.sh'],
  }

  if ! empty($sandstorm_key) {
    twitch_sandstorm_agent::template { 'global.conf':
      ensure          => $ensure,
      mode            => '0444',
      destination     => "${conf_dir}/global.conf",
      restart_command => '/usr/sbin/service vividcortex restart',
      contents        => template("${module_name}/global.conf.erb"),
      require         => File[$conf_dir],
    }

    if $ensure == 'present' {
      exec { 'install_vivid_cortex':
        command  => '/var/lib/vividcortex/install_auto.sh 2>&1 | logger -t vividcortex_installer -p local3.info',
        provider => 'shell',
        creates  => '/usr/local/bin/vc-agent-007',
        require  => [
          File['/var/lib/vividcortex/install_auto.sh'],
          Twitch_sandstorm_agent::Template['global.conf'],
        ],
      }

      service { 'vividcortex':
        ensure    => 'running',
        enable    => true,
        subscribe => Exec['install_vivid_cortex'],
      }
    }
  }
  else {
    notify { 'Vivid cortex will not be installed automatically due to missing API token!': }
  }

  if $ensure == 'absent' {
    service { 'vividcortex':
      ensure => 'stopped',
      enable => false,
    }

    exec { 'uninstall_vivid_cortex':
      command  => '(echo y | /var/lib/vividcortex/install.sh --uninstall) 2>&1 | logger -t vividcortex_installer -p local3.info',
      provider => 'shell',
      onlyif   => 'test -f /usr/local/bin/vc-agent-007',
      require  => [
        File['/var/lib/vividcortex/install.sh'],
        Service['vividcortex'],
      ],
    }
  }
}
