# twitchtv::app::config allows you to override specific variables from the
# staging.json config file.
class twitchtv::app::config (
  $envdir                = "/opt/twitch/web/etc/env",
  $api_hostport          = undef,
  $alt_api_hostport      = undef,
  $cdn_hostport          = undef,
  $swf_hostport          = undef,
  $unsecure_hostport     = undef,
  $secure_hostport       = undef,
  $ember_url             = undef,
  $ember_hostport        = undef,
  $ember_path            = undef,
  $styles_url            = undef,
  $statsd_env            = undef,
  $redis_host            = undef,
  $redis_port            = undef,
  $rabbit_vods_host      = undef
) inherits twitchtv::params {
  # Create the $envdir and delete unmanaged files.
  file { $envdir:
    ensure  => directory,
    owner   => root,
    group   => root,
    mode    => '0555',
    purge   => true,
    recurse => true,
  }

  daemontools::envdir { "twitch.twitch.api_hostport":
    base_dir => $envdir,
    value    => $api_hostport,
  }

  daemontools::envdir { "twitch.twitch.alt_api_hostport":
    base_dir => $envdir,
    value    => $alt_api_hostport,
  }

  daemontools::envdir { "twitch.twitch.cdn_hostport":
    base_dir => $envdir,
    value    => $cdn_hostport,
  }

  daemontools::envdir { "twitch.twitch.swf_hostport":
    base_dir => $envdir,
    value    => $swf_hostport,
  }

  daemontools::envdir { "twitch.twitch.unsecure.hostport":
    base_dir => $envdir,
    value    => $unsecure_hostport,
  }

  daemontools::envdir { "twitch.twitch.secure.hostport":
    base_dir => $envdir,
    value    => $secure_hostport,
  }

  daemontools::envdir { "twitch.ember.url":
    base_dir => $envdir,
    value    => $ember_url,
  }

  daemontools::envdir { "twitch.ember.hostport":
    base_dir => $envdir,
    value    => $ember_hostport,
  }

  daemontools::envdir { "twitch.ember.path":
    base_dir => $envdir,
    value    => $ember_path,
  }

  daemontools::envdir { "twitch.styles.default":
    base_dir => $envdir,
    value    => $styles_url
  }

  daemontools::envdir { "twitch.statsd.environment":
    base_dir => $envdir,
    value    => $statsd_env
  }

  daemontools::envdir { "twitch.redis.app_settings.connection_options.host":
    base_dir => $envdir,
    value    => $redis_host
  }

  daemontools::envdir { "twitch.redis.app_settings.connection_options.port":
    base_dir => $envdir,
    value    => $redis_port
  }

  daemontools::envdir { "twitch.rabbit_vods.host":
    base_dir => $envdir,
    value    => $rabbit_vods_host
  }
}
