class twitchtv::app::secrets(
  $web_env,
  $requires_iam_credentials = false
) {
  twitchtv::app::secrets::secret {
    [
      '__dbconns.common_octopus.password',
      '__dbconns.common_octopus.username',
      '__dbconns.common_postgresql.password',
      '__dbconns.common_postgresql.username',
      'algolia.api_key',
      'algolia.application_id',
      'amazon.s3.keys.twitch-aws.access_key_id',
      'amazon.s3.keys.twitch-aws.secret_access_key',
      'amazon.s3.keys.twitch-video-aws.access_key_id',
      'amazon.s3.keys.twitch-video-aws.secret_access_key',
      'attr_encrypted.payout_entity_key',
      'attr_encrypted.twitter_user_key',
      'authy.api_key',
      'battlenet.client_id',
      'battlenet.client_secret',
      'bits_audits.access_key_id',
      'bits_audits.secret_access_key',
      'creative_s3.access_key_id',
      'creative_s3.secret_access_key',
      'desk_sso.api_key',
      'desk.user',
      'desk.password',
      'dfp.authentication.oauth2_client_id',
      'dfp.authentication.oauth2_client_secret',
      'dfp.authentication.oauth2_token.refresh_token',
      'fuel.oauth_client.id',
      'fuel.oauth_client.secret',
      'google_calendar.certificate_secret',
      'im_store.secret',
      'jax_rollbar.api_key',
      'liverail.email',
      'liverail.password',
      'mailchimp.api_key',
      'mixpanel.api_key',
      'mixpanel.api_secret',
      'mixpanel.token',
      'oauth2.site_client_id',
      'oauth2.site_id',
      'oauth2.site_login_id',
      'orbis.api_client_secret',
      'orbis.platform_key_1',
      'orbis.platform_key_2',
      'pagerduty.integration_key',
      'passport.client_id',
      'passport.rotating_client_secrets.secrets_01',
      'passport.rotating_client_secrets.secrets_02',
      'passport.rotating_client_secrets.api.secrets_01',
      'passport.rotating_client_secrets.api.secrets_02',
      'passport.rotating_client_secrets.session.secrets_01',
      'passport.rotating_client_secrets.session.secrets_02',
      'passport.rotating_client_secrets.id_token.secrets_01',
      'passport.rotating_client_secrets.id_token.secrets_02',
      'passport.rotating_client_secrets.state.secrets_01',
      'passport.rotating_client_secrets.state.secrets_02',
      'payments_rollbar.api_key',
      'paypal.login',
      'paypal.password',
      'paypal.signature',
      'prerender.token',
      'rabbit.connection_options.mq_password',
      'rabbit.connection_options.mq_username',
      'rails.hmac_key',
      'rails.nauth_hmac_key',
      'rails.secret_token',
      'rails.sudo_token',
      'recaptcha.private_key',
      'recaptcha.public_key',
      'recurly.api_key',
      'recurly.js_key',
      'redis.app_settings.connection_options.password',
      'rollbar.api_key',
      'searchindexer.kinesis.aws_access_key_id',
      'searchindexer.kinesis.aws_secret_access_key',
      'smartling.api_key',
      'swift.key',
      'swift.user',
      'swiftype.api_key',
      'teespring.token',
      'tipalti.key',
      'tipalti.payer',
      'twilio.account_sid',
      'twilio.auth_token',
      'valkyrie.private_key',
      'xsolla.secret_key',
      'xsolla_v3.api_key',
      'xsolla_v3.secret_key',
      'youtube_rollbar.api_key'
    ]:
      web_env => $web_env,
      team_name => 'web-rails',
      app_name => 'app'
  }

  case $web_env {
    'staging': {
      twitchtv::app::secrets::secret {
        [
          'SWS_BETA_CHAIN_CERT_KEY'
        ]:
          destination_path => 'tails.cert_key_chain',
          web_env => 'production',
          team_name => 'commerce',
          app_name => 'payday'
      }
    }
    default: {
      twitchtv::app::secrets::secret {
        [
          'sws-prod-cert'
        ]:
          destination_path => 'tails.cert_key_chain',
          web_env   => 'production',
          team_name => 'commerce',
          app_name  => 'payday'
      }
    }
  }

  if $requires_iam_credentials {
    twitchtv::app::secrets::secret {
      [
        'kinesis.credentials.access_key_id',
        'kinesis.credentials.secret_access_key',
        'sns.credentials.access_key_id',
        'sns.credentials.secret_access_key'
      ]:
        web_env => $web_env,
        team_name => 'web-rails',
        app_name => 'app'
    }
  }

  twitchtv::app::secrets::secret { 'dynamo_access_key_id':
     destination_path => 'dms.access_key_id',
     web_env   => $web_env,
     team_name => 'commerce',
     app_name  => 'dms'
  }

  twitchtv::app::secrets::secret { 'dynamo_secret_access_key':
     destination_path => 'dms.secret_access_key',
     web_env   => $web_env,
     team_name => 'commerce',
     app_name  => 'dms'
  }

  twitchtv::app::secrets::secret { 'beefcake.api_key':
    destination_path => 'beefcake.api_key',
    web_env => $web_env,
    team_name => 'web-rails',
    app_name => 'beefcake'
  }

  twitchtv::app::secrets::secret { 'duo.skey':
    destination_path => 'duo.skey',
    web_env => $web_env,
    team_name => 'web-rails',
    app_name => 'admin-panel'
  }
}
