define twitchtv::app::secrets::secret(
  $env_dir = "/opt/twitch/web/etc/env",
  $app_dir = "/opt/twitch/web/current",
  $destination_path = "${name}",
  $web_env,
  $team_name,
  $app_name
) {
  validate_string($destination_path, $web_env, $team_name, $app_name)

  $key = "${team_name}/${app_name}/${web_env}/${name}"
  $destination = "${env_dir}/twitch.${destination_path}"
  twitch_sandstorm_agent::template { "${web_env}-${name}":
    destination     => $destination,
    restart_command => "sudo -u jtv ${app_dir}/courier/restart.sh",
    key             => $key,
    require         => File[$env_dir],
  }

  # required so the file is managed by puppet and doesn't get purged
  file { $destination:
    ensure  => 'present',
    replace => false,
    content => '',
    mode    => '0644',
  }
}
