class twitchtv::crons::appcrons (
) {
  include twitch::roles::rails_worker
  include twitch::users::jtv

  $prelude   = "[ -f /home/jtv/cronscripts/jtvenv ] && . /home/jtv/cronscripts/jtvenv ; cd /opt/twitch/web/current"

  file { '/home/jtv/cronscripts/jtvenv':
    ensure  => present,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0644',
    source  => 'puppet:///modules/twitchtv/jtvenv',
    require => Class['twitch::users::jtv'],
  }

  daemontools::supervise { 'crono_jobs':
    daemon_dir     => '/var/lib/service',
    user           => 'jtv',
    syslog         => local3,
    wd             => "/opt/twitch/web/current",
    daemon         => "bundle exec crono",
    options        => $options,
    predaemon      => [
      'export PATH=/home/jtv/.rbenv/bin:/home/jtv/.rbenv/shims:$PATH RBENV_ROOT=/home/jtv/.rbenv/ HOME=/home/jtv',
      'export RAILS_ENV=production',
      'exec 2>&1',
    ]
  }

  # env - `cat ~/.cronenv` /bin/sh
  cron { 'capture_cron_environment':
    ensure      => present,
    user        => 'jtv',
    environment => ['SHELL=/bin/bash', 'MAILTO=web@justin.tv'],
    command     => "env > ~/cronenv"
  }
}
