# Used by rails-nginx-api

class twitchtv::sites::api (
  $web_env                = hiera('web_env', 'production'),
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $document_root          = '/opt/twitch/web/current/public',
  $secure_hostname        = 'secure.twitch.tv',
  $api_hostname           = 'api.twitch.tv',
  $ssl_redirect_hostname  = 'www.twitch.tv',
  $additional_hostnames   = '',
  $additional_api_hostnames = 'api-origin.twitch.tv gql-origin.twitch.tv',
  $additional_cdn_hostnames = '',
  $additional_secure_hostnames = '',
  $ssl_secure_redirect_hostname = 'secure.twitch.tv',
  $web_client_hostname    = 'internal-internal-web-client-1824389474.us-west-2.elb.amazonaws.com',
  $admin_vhost            = 'admin.internal.twitch.tv',
  $twice_port             = 3500,
  $appcache_port          = 6650,
  $disable_internal_api   = false,
  $twitch_player_base     = 'www-cdn.jtvnw.net',
  $dns_server             = '127.0.0.1',
  $visage_endpoint        = 'visage-origin.twitch.tv',
  $rails_api_varnish_alb  = 'localhost:6650',
  $streams_elb            = 'internal-streams-api-production-1407242522.us-west-2.elb.amazonaws.com',
  $payday_elb             = 'payday.prod.us-west2.justin.tv',
  $creative_elb           = 'internal-communities-production-app-1506573533.us-west-2.elb.amazonaws.com',
  $discovery_elb          = 'internal-discovery-production-1973781938.us-west-2.elb.amazonaws.com',
  $interpol_host          = 'id.twitch.tv',
  $payday_bypass_cartman  = false,
  $prerender_ssl          = undef,
  $prerender_host         = undef,
  $prerender_token        = undef,
) {
  include twitch_nginx
  include twitch::nginxips
  include twitchtv::web::app
  include tmi_client
  include twitch_player
  include twitchtv::app::code

  $nameservers     = hiera('twitch_nameservers')
  $nginx_conf_dir  = $twitch_nginx::params::nginx_conf_dir
  $svc_name        = 'twitchtv'

  $kraken_upstream = "${svc_name}_kraken"
  $visage_upstream = "visage"
  $kraken_endpoint = "${rails_api_varnish_alb}"

  ::twitch_nginx::vhost{ 'api':
    content => template('twitchtv/nginx/api.conf.erb'),
    require => File["${nginx_conf_dir}/${svc_name}_acl.conf"],
  }

}
