# vhost for justin.tv.

class twitchtv::sites::justintv {
  include twitch_nginx
  include twitch::nginxips
  include twitchtv::web::justintv
  include twitch::users::jtv

  $nginx_conf_dir  = $twitch_nginx::nginx_conf_dir
  $svc_name        = 'justintv'

  file { "${nginx_conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => root,
    group   => root,
    mode    => '0644',
    source  => 'puppet:///modules/twitchtv/nginx/web_acl.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }

  ::twitch_nginx::vhost{ 'justintv':
    ensure  => absent,
  }

  ::twitch_nginx::vhost{ 'jtvisdead':
    source => 'puppet:///modules/twitchtv/nginx/jtvisdead.conf',
  }

  file{ '/home/jtv/goodbyejtv':
    ensure  => directory,
    owner   => 'jtv',
    group   => 'jtv',
    recurse => true,
    source  => 'puppet:///modules/twitchtv/jtv_static',
    require => Class['twitch::users::jtv'],
  }

}
