# Staging web
class twitchtv::sites::stagingapi (
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $document_root          = '/opt/twitch/web/current/public',
  $secure_hostname        = 'secure-staging.twitch.tv',
  $api_hostname           = 'stagingapi.twitch.tv',
  $ssl_redirect_hostname  = 'staging.twitch.tv',
  $additional_hostnames   = 'staging.twitch.tv',
  $additional_api_hostnames = 'api-origin-staging.twitch.tv',
  $additional_cdn_hostnames = '',
  $additional_secure_hostnames = '',
  $web_client_hostname    = 'internal-internal-web-client-1824389474.us-west-2.elb.amazonaws.com',
  $ssl_secure_redirect_hostname = 'secure-staging.twitch.tv',
  $admin_vhost            = 'admin-staging.twitch.tv',
  $twice_port             = 2000,
  $appcache_port          = 2000,
  $consul_service_name    = 'web-nginx-twitchtv',
  $consul_port            = 80,
  $consul_tags            = ['staging'],
  $disable_internal_api   = false,
  $twitch_player_base     = $additional_hostnames,
  $visage_elb             = 'visage.staging.us-west2.justin.tv',
  $rails_api_varnish_alb  = 'localhost:2000',
  $streams_elb            = 'streams-api.dev.us-west2.justin.tv',
  $payday_elb             = 'payday.staging.us-west2.justin.tv',
  $creative_elb           = 'communities.staging.us-west2.justin.tv',
  $discovery_elb          = 'internal-discovery-production-1973781938.us-west-2.elb.amazonaws.com',
  $interpol_host          = 'id-dev.twitch.tv',
  $payday_bypass_cartman  = true,
  $prerender_ssl          = undef,
  $prerender_host         = undef,
  $prerender_token        = undef,
) {
  include twitch_nginx
  include tmi_client
  include twitch_player

  $nameservers     = hiera('twitch_nameservers')
  $nginx_conf_dir  = $twitch_nginx::params::nginx_conf_dir
  $svc_name        = 'staging'
  # This environment points to a mix of production and staging which live in
  # different VPCs, so we cannot use the Amazon VPC DNS resolver.
  # Instead, we'll default to using the Twitch nameservers.
  $dns_server      = join($nameservers, ' ')

  $visage_upstream = "visage"
  $kraken_upstream = "${svc_name}_kraken"
  $kraken_endpoint = "localhost:${kraken_port}"
  $visage_endpoint = $visage_elb
  $visage_canary_endpoint = $visage_elb # For staging we don't have an explicit canary
  $visage_eb_endpoint = $visage_elb

  ::twitch_nginx::vhost{ 'stagingapi':
    content => template('twitchtv/nginx/api.conf.erb'),
    require => File["${nginx_conf_dir}/${svc_name}_acl.conf"],
  }

}
