class twitchtv::sites::twitchadmin (
  $web_env             = hiera('web_env', 'production'),
  $vhost               = 'admin.internal.twitch.tv',
  $site_vhost          = 'www.twitch.tv',
  $appcache_port       = 6650,
  $consul_service_name = 'web-nginx-admin',
  $consul_port         = 80,
  $consul_tags         = [hiera('web_env', 'production')]
) {
  include twitch::nginxips
  include twitchtv::web::api

  ::twitch_nginx::vhost{ 'twitchadmin':
    content => template("twitchtv/nginx/twitchadmin.conf.erb"),
  }

  unless hiera('clean') {
    consul::service { "web-nginx-admin-${web_env}":
      service_name   => $consul_service_name,
      port           => $consul_port,
      consul_tags    => $consul_tags,
    }
  }
}
