# Used by rails-nginx? -dnewhall@4/7/17

class twitchtv::sites::twitchtv (
  $web_env                = hiera('web_env', 'production'),
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $document_root          = '/opt/twitch/web/current/public',
  $secure_hostname        = 'secure.twitch.tv',
  $ssl_redirect_hostname  = 'www.twitch.tv',
  $additional_hostnames   = '',
  $additional_cdn_hostnames = '',
  $additional_secure_hostnames = '',
  $ssl_secure_redirect_hostname = 'secure.twitch.tv',
  $web_client_hostname    = 'internal-internal-web-client-1824389474.us-west-2.elb.amazonaws.com',
  $admin_vhost            = 'admin.internal.twitch.tv',
  $twice_port             = 3500,
  $appcache_port          = 6650,
  $disable_internal_api   = false,
  $twitch_player_base     = 'www-cdn.jtvnw.net',
  $dns_server             = '169.254.169.253',
  $payday_elb             = 'payday.prod.us-west2.justin.tv',
  $creative_elb           = 'internal-communities-production-app-1506573533.us-west-2.elb.amazonaws.com',
  $discovery_elb          = 'internal-discovery-production-1973781938.us-west-2.elb.amazonaws.com',
  $interpol_host          = 'id.twitch.tv',
  $payday_bypass_cartman  = false,
  $prerender_ssl          = undef,
  $prerender_host         = undef,
  $prerender_token        = undef,
) {
  include twitch_nginx
  include twitch::nginxips
  include twitchtv::web::app
  include tmi_client
  include twitch_player
  include twitchtv::app::code

  $nameservers     = hiera('twitch_nameservers')
  $nginx_conf_dir  = $twitch_nginx::params::nginx_conf_dir
  $svc_name        = 'twitchtv'

  $ember_traffic_migration_endpoints = [
    '= /vidhurv'
  ]

  ::twitch_nginx::vhost{ 'twitchtv':
    content => template('twitchtv/nginx/twitchtv.conf.erb'),
    require => File["${nginx_conf_dir}/${svc_name}_acl.conf"],
  }

  file { "${nginx_conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitchtv/nginx/web_acl.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
