# This is probably not used anymore, but it's loaded by rails-nginx. -dnewhall@4/7/17

class twitchtv::sites::wwwcdnjtv (
  $web_env                = hiera('web_env', 'production'),
  $twitch_player_location = '/opt/twitch/twitch_player',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $twitch_code_location   = '/opt/twitch/web',
  $document_root          = '/opt/twitch/web/current/public/',
  $jtv_root               = '/opt/twitch/jtv-root',
  $service_hostname       = 'www-origin.justin.tv',
  $twice_port             = 3500,
  $kraken_port            = 6650,
  $consul_service_name    = 'web-nginx-cdn',
  $consul_port            = 80,
  $consul_tags            = [hiera('web_env', 'production')],
  $twitch_player_base     = 'www-cdn.jtvnw.net',
) {
  include twitch_nginx
  include twitch::nginxips
  include twitchtv::web::justintv

  $nginx_conf_dir  = $twitch_nginx::params::nginx_conf_dir
  $svc_name        = 'wwwcdnjtv'

  ::twitch_nginx::vhost{ 'wwwcdnjtv':
    content => template("twitchtv/nginx/${svc_name}.conf.erb"),
    require => File["${nginx_conf_dir}/${svc_name}_acl.conf"],
  }

  file { "${nginx_conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitchtv/nginx/web_acl.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
