# WWW CDN Staging
class twitchtv::sites::wwwcdnstaging (
  $web_env                = hiera('web_env', 'staging'),
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $twice_port             = 3501,
  $kraken_port            = 5501,
  $document_root          = '/opt/twitch/web/current/public/',
  $jtv_root               = '/opt/twitch/jtv-root',
  $service_hostname       = 'www-cdn-staging.jtvnw.net',
  $consul_service_name    = 'web-nginx-cdn',
  $consul_port            = 80,
  $consul_tags            = [hiera('web_env', 'staging')],
  $twitch_player_base     = $service_hostname,
) {
  include twitch_nginx
  include twitch::nginxips
  include tmi_client
  include twitch_player

  $nginx_conf_dir  = $twitch_nginx::params::nginx_conf_dir
  $svc_name        = 'wwwcdnstaging'

  ::twitch_nginx::vhost{ 'wwwcdnstaging':
    content => template('twitchtv/nginx/wwwcdnjtv.conf.erb'),
    require => File["${nginx_conf_dir}/${svc_name}_acl.conf"],
  }

  file { "${nginx_conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitchtv/nginx/web_acl.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
