class twitchtv::web::common (
) {
  include core
  include twitch_nginx
  include twitch::crossdomain
  include twitch::sureroute
  include twitch::users::common
  include twitch::haproxy::web
  include twitch::packages

  realize(Package['libxslt1-dev'])
  realize(Package['libxml2-dev'])
  realize(Package['libcurl4-openssl-dev'])
  realize(Package['libsasl2-dev'])

  $nginx_conf_dir = $twitch_nginx::params::nginx_conf_dir

  # TODO: only used for emoticon cron hack. You can remove www-root after that is gone.
  file { '/home/jtv/www-root':
    ensure  => directory,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0755',
    require => Class['twitch::users::jtv']
  }
}
