class twitchtv::workers::webapp_worker (
  $web_env                = $twitchtv::workers::params::web_env,
  $consul_env             = $web_env,
  $rails_dir              = $twitchtv::workers::params::rails_dir,
  $hutch_worker_instances = $twitchtv::workers::params::hutch_worker_instances,
  $app_base_dir           = $twitchtv::workers::params::app_base_dir,
  $app_project            = $twitchtv::workers::params::app_project,
  $app_name               = $twitchtv::workers::params::app_name,
) inherits twitchtv::workers::params {

  include 'twitch::packages'
  include 'twitchtv::packages'
  include twitchtv

  $log_dir = "${app_base_dir}/${app_name}/shared/log"
  $tmp_dir = "${app_base_dir}/${app_name}/shared/tmp"
  $env_dir = "${app_base_dir}/${app_name}/etc/env"

  #This prevents duplicate class declarations on our rails staging boxes
  if $clean and ($twitch_environment == 'production') {
    class { "twitchtv::app::code":
      app_base_dir => $app_base_dir,
      project      => $app_project,
      deploy_env   => $web_env,
      app_name     => $app_name,
      require      => [
        Class['twitch_ruby::rbenv'],
        Daemontools::Supervise['web-workers-hutch'],
        Class['consul'],
        Service['consul']
      ]
    }

    file{ $log_dir:
      ensure  => directory,
      owner   => 'jtv',
      group   => 'jtv',
      mode    => '0755',
      require => Class['twitchtv::app::code'],
    }

    file{ $tmp_dir:
      ensure  => directory,
      owner   => 'jtv',
      group   => 'jtv',
      mode    => '0755',
      require => Class['twitchtv::app::code'],
    }
  }

  # create daemontools tasks to manage workers
  daemontools::supervise { 'web-workers-hutch':
    user      => 'jtv',
    syslog    => local3,
    wd        => "${rails_dir}/current",
    daemon    => "envdir ${env_dir} script/run_web_worker",
    options   => $options,
    predaemon => [
                  'export LANG="en_US.UTF-8" LANGUAGE="en_US.UTF-8" LC_ALL="en_US.UTF-8"',
                  'export HOME=/home/jtv',
                  "export RAILS_ENV=${web_env}",
                  "export NB_HUTCH_WORKERS=${hutch_worker_instances}",
                  'export RBENV_ROOT=/home/jtv/.rbenv/',
                  'eval "$(rbenv init -)"',
                  'exec 2>&1',
                  ]
  }

  # create daemontools tasks to manage workers
  daemontools::supervise { 'web-workers-nsq':
    down      => 'force',
    daemon    => 'script/run_nsq_worker',   
    wd        => "${rails_dir}/current"
  }

  # if *_worker > 400MB, then something is wrong--kill it
  cron{ 'webapp_worker_memory_check':
    ensure  => present,
    user    => 'jtv',
      command => "ps -Ao rss,pid,cmd | grep 'webapp_worker' |  awk '{ if (\$1 > 400000) {print \$2,\$1\"KB\" ; system(\"sudo kill -HUP \"\$2) }}' | xargs -r  logger -p local2.info -t hutch_worker_memory_check killing pid",
  }

  if hiera('clean') {
    consul::service { 'web-rails-worker-hutch':
      consul_tags => [$twitchtv::consul_deploy_tag],
    }
  } else {
    consul::service { 'web-worker-webapp':
      consul_tags => [$twitchtv::consul_deploy_tag],
    }
  }
}
