define users::create (
  $uid                 = undef,
  $gid                 = undef,
  $groups              = undef,
  $password            = undef,
  $ensure              = 'present',
  $shell               = '/bin/bash',
  $ssh_authorized_keys = [],
  $home                = undef,
  $home_basedir        = '/home',
  $managehome          = true,
  $system              = false,
  $forcelocal          = false,
  $ssh_priv_keys       = [],
  $ssh_config_opts     = {},
) {

  validate_absolute_path($shell, $home_basedir)
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_bool($managehome)
  validate_hash($ssh_config_opts)

  # if home has been passed in, use it
  if $home != undef {
    $real_home = $home
  } else {
    $real_home = "${home_basedir}/${name}"
  }
  validate_absolute_path($real_home)
  # create the user and their home directory
  user { $name:
    ensure     => $ensure,
    home       => $real_home,
    managehome => $managehome,
    password   => $password,
    shell      => $shell,
    uid        => $uid,
    gid        => $gid,
    groups     => $groups,
    system     => $system,
    forcelocal => $forcelocal,
  }

  $ssh_dir = "${real_home}/.ssh"
  $ssh_dir_ensure = $ensure ? {
    'absent'  => 'absent',
    'present' => 'directory',
  }

  # create the user's .ssh directory
  file { $ssh_dir:
    ensure  => $ssh_dir_ensure,
    owner   => $name,
    group   => $name,
    mode    => '0700',
    require => User[$name],
  }

  users::authorizedkey { $ssh_authorized_keys:
    user    => $name,
    require => File[$ssh_dir]
  }

  users::privkey { $ssh_priv_keys:
    user    => $name,
    ssh_dir => $ssh_dir,
    require => File[$ssh_dir],
  }

  users::user_ssh_config { $name:
    ssh_dir         => $ssh_dir,
    ssh_config_opts => $ssh_config_opts,
    require         => File[$ssh_dir],
  }
}
