class users_service::install inherits users_service {
  if str2bool($is_canary) {
    $consul_tags = [$deploy_env, "${deploy_env}-canary"]
  } else {
    $consul_tags = [$deploy_env]
  }

  consul::service { 'deploy-target-users-service':
    consul_tags => $consul_tags,
  }

  courier::install { 'users-service':
    env     => $deploy_env,
    repo    => "web/users-service",
    require => Consul::Service['deploy-target-users-service'],
  }

  file { $envdir:
    ensure  => directory,
    owner   => root,
    group   => root,
    mode    => '0555',
    recurse => true,
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-db_user":
    destination     => "${envdir}/DB_USER",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/db_user",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-db_password":
    destination     => "${envdir}/DB_PASSWORD",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/sitedb_password",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-reservation_db_user":
    destination     => "${envdir}/RESERVATION_DB_USER",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/reservation_db_user",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-reservation_db_password":
    destination     => "${envdir}/RESERVATION_DB_PASSWORD",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/reservation_db_password",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-rollbar_token":
    destination     => "${envdir}/ROLLBAR_TOKEN",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/rollbar_token",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-redis_pass":
    destination     => "${envdir}/REDIS_PASS",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/redis_pass",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-legacy_aws_key":
    destination     => "${envdir}/LEGACY_AWS_KEY",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/legacy_aws_key",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-legacy_aws_secret":
    destination     => "${envdir}/LEGACY_AWS_SECRET",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/legacy_aws_secret",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-rollbar_api_token":
    destination     => "${envdir}/ROLLBAR_API_TOKEN",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/rollbar_api_token",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-twilio_auth":
    destination     => "${envdir}/TWILIO_AUTH",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/twilio_auth",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-twilio_account":
    destination     => "${envdir}/TWILIO_ACCOUNT",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/twilio_account",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-twilio_phone_numbers":
    destination     => "${envdir}/TWILIO_PHONE_NUMBERS",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/twilio_phone_numbers",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-leviathan_token":
    destination     => "${envdir}/LEVIATHAN_TOKEN",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "web-rails/users-service/${deploy_env}/leviathan_token",
    require         => File[$envdir],
  }

  twitch_sandstorm_agent::template { "${deploy_env}-users-service-cartman_key":
    destination     => "${envdir}/CARTMAN_KEY",
    restart_command => 'sudo svc -t /etc/service/users-service',
    key             => "identity/cartman/${deploy_env}/ecc_public_key",
    require         => File[$envdir],
  }

  daemontools::supervise { 'users-service':
    daemon_dir     => '/var/lib/service',
    user           => 'nobody',
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => '/opt/twitch/users-service/current',
    daemon         => "envdir ${envdir} ./users-service 2>&1",
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
      "export STATSD_HOST_PORT=localhost:8125",
      "export DB_HOST=${db_host}",
      "export DB_PORT=${db_port}",
      "export DB_NAME=${db_name}",
      "export DB_MAX_OPEN_CONNS=${db_max_open_conns}",
      "export DB_MAX_IDLE_CONNS=${db_max_idle_conns}",
      "export DB_MAX_QUEUE_SIZE=${db_max_queue_size}",
      "export DB_CONN_AQUIRE_TIMEOUT_MS=${db_conn_aquire_timeout_ms}",
      "export DB_REQUEST_TIMEOUT_MS=${db_request_timeout_ms}",
      "export DB_MAX_CONN_AGE_MS=${db_max_conn_age_ms}",

      "export DB_HOST_SLAVE=${db_host_slave}",
      "export DB_PORT_SLAVE=${db_port_slave}",
      "export DB_NAME_SLAVE=${db_name_slave}",
      "export DB_MAX_OPEN_CONNS_SLAVE=${db_max_open_conns_slave}",
      "export DB_MAX_IDLE_CONNS_SLAVE=${db_max_idle_conns_slave}",
      "export DB_MAX_QUEUE_SIZE_SLAVE=${db_max_queue_size_slave}",
      "export DB_CONN_AQUIRE_TIMEOUT_MS_SLAVE=${db_conn_aquire_timeout_ms_slave}",
      "export DB_REQUEST_TIMEOUT_MS_SLAVE=${db_request_timeout_ms_slave}",
      "export DB_MAX_CONN_AGE_MS_SLAVE=${db_max_conn_age_ms_slave}",

      "export DB_HOST_MASTER=${db_host_master}",
      "export DB_PORT_MASTER=${db_port_master}",
      "export DB_NAME_MASTER=${db_name_master}",
      "export DB_MAX_OPEN_CONNS_MASTER=${db_max_open_conns_master}",
      "export DB_MAX_IDLE_CONNS_MASTER=${db_max_idle_conns_master}",
      "export DB_MAX_QUEUE_SIZE_MASTER=${db_max_queue_size_master}",
      "export DB_CONN_AQUIRE_TIMEOUT_MS_MASTER=${db_conn_aquire_timeout_ms_master}",
      "export DB_REQUEST_TIMEOUT_MS_MASTER=${db_request_timeout_ms_master}",
      "export DB_MAX_CONN_AGE_MS_MASTER=${db_max_conn_age_ms_master}",
      "export RAILS_HOST=${rails_host}",

      "export RESERVATION_DB_NAME=${reservation_db_name}",

      "export RESERVATION_DB_HOST_SLAVE=${reservation_db_host_slave}",
      "export RESERVATION_DB_PORT_SLAVE=${reservation_db_port_slave}",
      "export RESERVATION_DB_MAX_OPEN_CONNS_SLAVE=${reservation_db_max_open_conns_slave}",
      "export RESERVATION_DB_MAX_IDLE_CONNS_SLAVE=${reservation_db_max_idle_conns_slave}",
      "export RESERVATION_DB_MAX_QUEUE_SIZE_SLAVE=${reservation_db_max_queue_size_slave}",
      "export RESERVATION_DB_CONN_AQUIRE_TIMEOUT_MS_SLAVE=${reservation_db_conn_aquire_timeout_ms_slave}",
      "export RESERVATION_DB_REQUEST_TIMEOUT_MS_SLAVE=${reservation_db_request_timeout_ms_slave}",
      "export RESERVATION_DB_MAX_CONN_AGE_MS_SLAVE=${reservation_db_max_conn_age_ms_slave}",

      "export RESERVATION_DB_HOST_MASTER=${reservation_db_host_master}",
      "export RESERVATION_DB_PORT_MASTER=${reservation_db_port_master}",
      "export RESERVATION_DB_MAX_OPEN_CONNS_MASTER=${reservation_db_max_open_conns_master}",
      "export RESERVATION_DB_MAX_IDLE_CONNS_MASTER=${reservation_db_max_idle_conns_master}",
      "export RESERVATION_DB_MAX_QUEUE_SIZE_MASTER=${reservation_db_max_queue_size_master}",
      "export RESERVATION_DB_CONN_AQUIRE_TIMEOUT_MS_MASTER=${reservation_db_conn_aquire_timeout_ms_master}",
      "export RESERVATION_DB_REQUEST_TIMEOUT_MS_MASTER=${reservation_db_request_timeout_ms_master}",
      "export RESERVATION_DB_MAX_CONN_AGE_MS_MASTER=${reservation_db_max_conn_age_ms_master}",

      "export REDISER_HOST=${rediser_host}",
      "export REDIS_HOST=${redis_host}",
      "export REDIS_PORT=${redis_port}",
      "export REDIS_CONNECT_TIMEOUT_MS=${redis_connect_timeout_ms}",
      "export REDIS_READ_TIMEOUT_MS=${redis_read_timeout_ms}",
      "export REDIS_WRITE_TIMEOUT_MS=${redis_write_timeout_ms}",
      "export REDIS_CONN=${redis_conn}",
      "export REDIS_USER_PROPERTIES_TTL_MS=${redis_user_properties_ttl_ms}",

      "export FOLLOWS_HOST=${follows_host}",

      "export USER_MUTATIONS_STREAM_NAME=${user_mutations_stream_name}",
      "export USER_MUTATIONS_STREAM_ROLE=${user_mutations_stream_role}",

      "export SNS_REGION=${sns_region}",
      "export USER_MODERATION_EVENTS_TOPIC_ARN=${user_moderation_events_topic_arn}",
      "export USER_RENAME_EVENTS_TOPIC_ARN=${user_rename_events_topic_arn}",
      "export USER_CREATION_EVENTS_TOPIC_ARN=${user_creation_events_topic_arn}",
      "export USER_MUTATION_EVENTS_TOPIC_ARN=${user_mutation_events_topic_arn}",
      "export CHANNEL_MUTATION_EVENTS_TOPIC_ARN=${channel_mutation_events_topic_arn}",
      "export PUSHY_DISPATCH_TOPIC_ARN=${pushy_dispatch_topic_arn}",
      "export USER_IMAGE_UPLOAD_EVENTS_TOPIC_ARN=${user_image_upload_events_topic_arn}",
      "export EMAIL_VERIFIED_TOPIC_ARN=${email_verified_topic_arn}",

      "export PARTNERSHIPS_HOST=${partnerships_host}",
      "export AUDITOR_HOST=${auditor_host}",

      "export MEMCACHED_HOST_PORTS=${memcached_host_ports}",
      "export MEMCACHED_AUTODISCOVERY=${memcached_autodiscovery}",
      "export MEMCACHED_CONN=${memcached_conn}",
      "export MEMCACHED_TIMEOUT=${memcached_timeout}",
      "export CACHE_BACKEND=${cache_backend}",
      "export CACHE_BACKEND_BACKUP=${cache_backend_backup}",

      "export TWILIO_DISABLED=${twilio_disabled}",
      "export LEVIATHAN_HOST=${leviathan_host}",

      "export GEOIP_PATH=${geoip_path}",
      "export DISCOVERY_HOST=${discovery_host}",
      "export CARTMAN_KEY_PATH=${cartman_key_path}",
      "export EVS_HOST=${evs_host}",
      "export UPLOAD_SERVICE_HOST=${upload_service_host}",
      "export SQS_REGION=${sqs_region}",
      "export EMAIL_VALIDATION_SUCCESS_NUM_WORKERS=${email_validation_success_num_workers}",
      "export EMAIL_VALIDATION_SUCCESS_QUEUE_NAME=${email_validation_success_queue_name}",
      "export IMAGE_UPLOAD_NUM_WORKERS=${image_upload_num_workers}",
      "export IMAGE_UPLOAD_QUEUE_NAME=${image_upload_queue_name}",
      "export DEAD_LETTER_QUEUE_NUM_WORKERS=${dead_letter_queue_num_workers}",
      "export DEAD_LETTER_QUEUE_NAME=${dead_letter_queue_name}",

      "export USER_SOFT_DELETE_EVENTS_TOPIC_ARN=${user_soft_delete_events_topic_arn}",
      "export USER_HARD_DELETE_EVENTS_TOPIC_ARN=${user_hard_delete_events_topic_arn}",
      "export USER_UNDELETE_EVENTS_TOPIC_ARN=${user_undelete_events_topic_arn}",

      "export OWL_HOST=${owl_host}",
      "export PUBSUB_HOST=${pubsub_host}",

    ],
    require        => [
      File[$envdir],
      Twitch_sandstorm_agent::Template["${deploy_env}-users-service-db_user",
        "${deploy_env}-users-service-db_password",
        "${deploy_env}-users-service-reservation_db_password",
        "${deploy_env}-users-service-rollbar_token",
        "${deploy_env}-users-service-legacy_aws_key",
        "${deploy_env}-users-service-legacy_aws_secret",
        "${deploy_env}-users-service-leviathan_token",
        "${deploy_env}-users-service-cartman_key",
        "${deploy_env}-users-service-rollbar_api_token",
        "${deploy_env}-users-service-redis_pass",
        "${deploy_env}-users-service-twilio_auth",
        "${deploy_env}-users-service-twilio_account",
        "${deploy_env}-users-service-twilio_phone_numbers"]
    ]
  }
}
