class usher (
  $start_port      = $usher::params::start_port,
  $concat_flags    = join(hiera_array('usher::flags', []), ' '),
  $config_name     = $usher::params::config_name,
  $env             = $usher::params::env,
  $type            = $usher::params::type,
  $haproxy_type    = $usher::params::haproxy_type,
  $instance_count  = $usher::params::instance_count,
  $staging_pop     = $usher::params::staging_pop

) inherits usher::params {
  # Validate that params being set via facts aren't empty strings and contain
  # at least one character:
  if !is_array($env) {
    validate_re($env, '.+')
  } else {
    validate_re($env[0], '.+')
  }

  class {"twitch::haproxy::${haproxy_type}_origin":
    instname    => "${type}-origin",
    ports       => better_range($start_port, $start_port + $instance_count - 1),
    consul_env  => $env,
    consul_name => "${type}-api-origin",
  }

  anchor { 'usher::begin': }
  -> class  { '::usher::setup': }
  -> class  { '::usher::supervise': }
  -> class  { '::usher::cron': }
  -> class  { '::usher::logrotate': }
  -> anchor { 'usher::end': }
}
