# Creates an Usher instance.

define usher::instance (
  $config_name,
  $concat_flags,
  $env,
  $type,
  $port = $name,
) {
  $svcname = "usher_${port}"

  if is_array($env) {
    $primary_env = $env[0]
  } else {
    $primary_env = $env
  }

  case $config_name {
    'find_config':      { $usher_bin = './api_find' }
    'usher_config':     { $usher_bin = './api_usher' }
    'videoapi_config':  { $usher_bin = './api_videoapi' }
    'video_config':     { fail('Usher running on video/ingest is not compatible with this module') }
    default:            { fail('Unrecognized Usher config -- be sure to add the wrapper to the usher module') }
  }

  twitch_cloudwatchlogs::log { "usher-${port}":
    service     => "usher-${config_name}",
    awslogs_env => $primary_env,
    path        => "/var/log/jtv/usher_${port}.log",
    streamname  => "${::fqdn}-${port}"
  }

  daemontools::supervise { $svcname:
    env            => $env,
    manage_service => true,
    syslog         => local3,
    wd             => '/home/jtv/usher/bin',
    predaemon      => [],
    daemon         => "${usher_bin} -p ${port} --user=nobody --no-timestamp --pop ${::pop} ${concat_flags} 2>&1",
  }

  consul::service { $svcname:
    service_name => "${type}-api",
    consul_tags  => concat([$type], $env),
    port         => $port,
  }
}
