# This makes log rotate run hourly for usher.

class usher::logrotate inherits usher {
  logrotate::rule{ 'usher_haproxy':
    ensure          => present,
    path            => [ '/var/log/jtv/usher_*.log', '/var/log/jtv/haproxy*.log' ],
    missingok       => true,
    olddir          => '/var/log/archive/',
    rotate          => 36,
    rotate_every    => 'hourly',
    sharedscripts   => true,
    create          => false,
    compress        => true,
    compresscmd     => '/bin/gzip',
    compressoptions => '-6',
    compressext     => '.gz',
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
  }
}
