# Parameters for usher class.

class usher::params {
  $start_port       = 8925
  $host_headroom    = 2
  $flags            = ''
  $config_name      = 'usher_config'
  $type             = 'usher'
  $haproxy_type     = 'usher'
  $env              = [$twitch_environment]
  $deploy_env       = $twitch_environment

  $instance_count   = $::processorcount - 2
  $usher_dir        = '/home/jtv/usher'
  $usher_host       = 'usher.justin.tv'
  $graphite_service = hiera('graphite_server')
  $graphite_split   = split($graphite_service, ':')
  $graphite_host    = $graphite_split[0]
  $graphite_port    = $graphite_split[1]

  $staging_pop          = 'sjc02'

  $usher_service_config = {
    'USHER_HOST'  => $usher_host,
    'STATSD_HOST' => $graphite_service,
  }
}
