class usher::services::broadcast_statsd (
  $ensure        = 'present',
  $env           = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency   = 0,
  $usher_dir     = $usher::params::usher_dir,
  $graphite_host = $usher::params::graphite_host,
) inherits usher::params {

  require usher::setup
  include twitch::haproxy::backend
  include twitch::haproxy::listeners::backend_usherdb_master

  $svcname = 'broadcast_statsd'
  daemontools::supervise{ $svcname:
    ensure         => $ensure,
    daemon_dir     => '/var/lib/service',
    syslog         => 'local3',
    wd             => "${usher_dir}/bin",
    user           => 'nobody',
    daemon         => "./${svcname} --statsd-host ${graphite_host} --pop ${::pop} 2>&1",
    require        => Class['twitch::haproxy::backend'],
    concurrency    => $concurrency,
    env            => $env,
    manage_service => true,
  }

  consul::service { "usher-daemon-${svcname}":
    ensure       => $ensure,
    service_name => 'usher-daemon',
    consul_tags  => [$svcname, $env],
  }

}
