class usher::services::edgecast_stats (
  $env                  = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency          = 0,
  $nop                  = false,
  $usher_dir            = $usher::params::usher_dir,
  $usher_service_config = $usher::params::usher_service_config,
) inherits usher::params {

  require usher::setup

  $svcname               = 'edgecast_stats'
  $edgecast_stats_config = parsejson(template('usher/edgecast_stats.conf.json'))
  validate_hash($edgecast_stats_config)

  video::configs { $svcname:
    svc_config => merge($usher_service_config, $edgecast_stats_config),
  }

  if $nop {
    $noop_flag = '--noop'
  }

  $daemon = "./edgecast_stats --config_file=/opt/twitch/${svcname}/etc/${svcname}.conf.json"

  daemontools::supervise { $svcname:
    daemon_dir  => '/var/lib/service',
    syslog      => 'local3',
    wd          => "${usher_dir}/bin",
    user        => 'nobody',
    predaemon   => ['. /etc/profile.d/proxy.sh 2>/dev/null'],
    daemon      => "${daemon} ${noop_flag} --pop ${::pop} 2>&1",
    require     => Video::Configs[$svcname],
    concurrency => $concurrency,
    env         => $env
  }

  consul::service { "usher-daemon-${svcname}":
    service_name => 'usher-daemon',
    consul_tags  => [$svcname, $env],
  }

}
