class usher::services::log_config_to_statsd (
  $ensure      = 'present',
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency = 0,
) inherits usher::params {

  require usher::setup
  include twitch::haproxy::backend
  include twitch::haproxy::listeners::backend_usherdb_master
  include twitch::haproxy::listeners::backend_video_api_http

  $svcname = 'log_config_to_statsd'
  daemontools::supervise { $svcname:
    ensure         => $ensure,
    daemon_dir     => '/var/lib/service',
    syslog         => 'local3',
    wd             => "${usher_dir}/bin",
    user           => 'nobody',
    daemon         => "./$svcname --daemon --statsd-host statsd.internal.justin.tv --usher-url http://127.0.0.1:12390/ --pop ${::pop} 2>&1",
    require        => Class['twitch::haproxy::backend'],
    concurrency    => $concurrency,
    env            => $env,
    manage_service => true,
  }

  consul::service { "usher-daemon-$svcname":
    ensure       => $ensure,
    service_name => "usher-daemon",
    consul_tags  => [$svcname, $env],
  }

}
