# This class installs 2x mixpanel_injectors side by side.
# it is designed to be applied in the FQDN hiera, to at MOST 3 machines
# at a time.
#
# [*server_number*]   REQUIRED
#       the server_number to use in the event sending delay, should be sequential
#
# [*server_count*]
#       total number of daemons running EVERYWHERE
#       this service currently cant run more than N instances anywhere at a time
class usher::services::mixpanel_injector (
  $server_number,
  $server_count = 4,
  $env          = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency  = 0,
  $usher_dir    = $usher::params::usher_dir,
) inherits usher::params {

  require usher::setup
  include twitch::haproxy::backend
  include twitch::haproxy::listeners::backend_usherdb_master
  include twitch::haproxy::listeners::backend_rabbit_cluster_hls_production

  $svcname = 'mixpanel_injector'
  daemontools::supervise { $svcname:
    daemon_dir  => '/var/lib/service',
    syslog      => 'local3',
    wd          => "${usher_dir}/bin",
    user        => 'nobody',
    daemon      => './mixpanel_inject',
    options     => "--daemon --server-count=${server_count} --server-number=${server_number} --pop ${::pop} 2>&1",
    require     => Class['twitch::haproxy::backend'],
    concurrency => $concurrency,
    env         => $env
  }

  consul::service { "usher-daemon-${svcname}":
    service_name => 'usher-daemon',
    consul_tags  => [$svcname, $env],
  }

}
