class usher::services::pgbouncer_statsd_injector(
  $env           = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency   = 0,
  $database_name = 'pgbouncer',
  $database_port = 12075,
  $database_host = 'localhost',
  $interval      = 3,
  $username      = 'usher',
  $password      = 'ratspourmarblehomes',
) inherits usher::params {
  require usher::setup
  require twitch::haproxy::listeners::backend_usherdb_master

  $cluster_name  = 'usher-pgbouncer'

  daemontools::supervise { "pgbouncer_stats_injector-${cluster_name}":
    syslog      => 'local3',
    daemon_dir  => '/var/lib/service',
    wd          => '/home/jtv/usher/bin',
    user        => 'nobody',
    options     => "--interval=${interval} --monitor-db 'host=${database_host} port=${database_port} dbname=${database_name} user=${username} password=${password}' --cluster-name=${cluster_name} --pop ${::pop} 2>&1",
    daemon      => './pgbouncer_statsd_inject',
    concurrency => $concurrency,
    env         => $env
  }

}
