class usher::services::pgstat_statsd(
  $env           = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency   = 0,
  $database_name = 'usher',
  $database_port = 12075,
  $database_host = 'localhost',
  $interval      = 5,
  $username      = 'usher_readonly',
  $password      = 'ratspourmarblehomes',
  $tables        = [
    'nodes',
    'streams',
    'flows',
    'hls_transcodes',
  ],
) inherits usher::params {
  require usher::setup
  require twitch::haproxy::listeners::backend_usherdb_master

  $cluster_name  = 'usher-pgbouncer'
  $_tables       = join($tables, ',')

  daemontools::supervise { "pgstat_statsd-${cluster_name}":
    syslog      => 'local3',
    daemon_dir  => '/var/lib/service',
    wd          => '/home/jtv/usher/bin',
    user        => 'nobody',
    options     => "--site-db 0 0 --usher-db 0 0 --interval=${interval} --monitor-db 'host=${database_host} port=${database_port} dbname=${database_name} user=${username} password=${password}' --cluster-name=${cluster_name} --database-name=${database_name} --tables=${_tables} --pop ${::pop} 2>&1",
    daemon      => './pg_stat_into_statsd',
    concurrency => $concurrency,
    env         => $env
  }

}
