class usher::services::usher_stale_objects_killer (
  $ensure      = 'present',
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $concurrency = 0,
) {

  require usher::setup
  include twitch::haproxy::backend
  include twitch::haproxy::listeners::backend_usherdb_master

  daemontools::supervise { 'usher_stale_objects_killer':
    ensure         => $ensure,
    syslog         => 'local3',
    daemon_dir     => '/var/lib/service',
    wd             => '/home/jtv/usher/bin',
    user           => 'nobody',
    daemon         => './usher_stale_objects_killer',
    options        => "--daemon --syslog --pop ${::pop} 2>&1",
    concurrency    => $concurrency,
    env            => $env,
    manage_service => true,
  }
}
