class usher::setup (
  $use_courier      = true,
  $deploy_env       = $twitch_environment,
  $project          = 'video/usher',
  $base_dir         = '/home/jtv',
  $staging_redirect = false,
  $ssl_ciphers      = hiera('ciphers::default'),
) {
  validate_bool($use_courier)
  validate_string($deploy_env)
  validate_absolute_path($base_dir)
  validate_re($project,'[A-Za-z0-9_]/[A-Za-z0-9_]')

  ::rsyslog::snippet { '41-stats_syslog':
    content => template("${module_name}/41-stats_syslog.conf.erb"),
  }

  if ($use_courier) {
    courier::install{ 'usher_deploy':
      env     => $deploy_env,
      repo    => $project,
      basedir => $base_dir,
    }

    file{ '/home/jtv/usher':
      target  => "${base_dir}/usher_deploy/current",
      owner   => 'jtv',
      require => Courier::Install['usher_deploy'],
    }
  }

  # These items (binary libraries, geoip database) are depended on by the deployed usher virtualenvs
  include postgresql::lib::devel
  include twitch_geoip

  # Added when we migrating from usher999 to usher-staging.
  # Adds a frontend for requests to usher.staging.twitch.tv:80
  # The require comes from the fqdn file for the host running this.
  if $staging_redirect {
    twitch_nginx::vhost{ 'staging_nginx2haproxy_redirect':
      content   => template('usher/staging_nginx2haproxy_redirect.conf'),
      subscribe => Twitch_sandstorm_agent::Template['usher_staging_justin_tv_crt', 'usher_staging_justin_tv_key', 'usher_staging_justin_tv_dhparams'],
    }
  }
}
