class vanalytics_etl (
  $vanalytics_etl_environment = $vanalytics_etl::params::vanalytics_etl_environment,
  $canary                     = $vanalytics_etl::params::canary,
  $go_max_procs               = $vanalytics_etl::params::go_max_procs,
  $base_dir                   = $vanalytics_etl::params::base_dir,
  $app_name                   = $vanalytics_etl::params::app_name,
  $app_dir                    = $vanalytics_etl::params::app_dir,
  $stream_name                = $vanalytics_etl::params::stream_name,
  $statsd_host_port           = $vanalytics_etl::params::statsd_host_port,
  $statsd_prefix              = $vanalytics_etl::params::statsd_prefix,
  $aws_region                 = $vanalytics_etl::params::aws_region
) inherits vanalytics_etl::params {

  $predaemon = "export ENVIRONMENT=${vanalytics_etl_environment} GOMAXPROCS=${go_max_procs} AWS_REGION=${aws_region}"
  twitch::service { 'vanalytics_etl':
    env                   => $vanalytics_etl_environment,
    canary                => $canary,
    daemon_cmd            => "bin/${app_name} -stream ${stream_name} -statsdHostPort ${statsd_host_port} -statsdPrefix ${statsd_prefix}",
    predaemon             => $predaemon,
    service_repo          => "vod/${app_name}",
    consul_check_script   => "/usr/lib/nagios/plugins/check_procs -c 1:1 -C ${app_name}",
    consul_check_interval => '30s',
  }

  cron { 'vanalytics_etl':
    command => '/opt/twitch/vanalytics_etl/current/bin/vanalytics_cron',
    user    => 'jtv',
    minute  => 0
  }
}
