# Vanity is a proof of concept server for doing go-get vanity urls and
# per-project home pages.
class vanity (
  $app_dir            = $vanity::params::app_dir,
  $user               = $vanity::params::user,
  $deploy_environment = $vanity::params::deploy_environment,
  $site_name          = $vanity::params::site_name,
  $port               = $vanity::params::port,
  $ip                 = $vanity::params::ip,
) inherits vanity::params {
  validate_absolute_path($app_dir)
  include vanity::monitoring

  $clean_deploy_env = hiera('clean', false) ? {
    true    => "clean-${deploy_environment}",
    default => $deploy_environment,
  }

  consul::service { 'vanity-deploytarget':
    consul_tags  => [$clean_deploy_env],
  }

  courier::install{ 'vanity':
    env     => $clean_deploy_env,
    repo    => 'release/vanity',
    require => [
      Daemontools::Supervise['vanity'],
    ]
  }

  daemontools::supervise { 'vanity':
    user        => $user,
    syslog      => 'local3',
    predaemon   => [
      '# vanity',
      '# desc: a go-get vanity server and per-project home page.',
      '# owner: devtools@twitch.tv',
      '# url: twcode.io/release/vanity',
      'export APP=vanity',
      "export APPDIR=${app_dir}",
      "export ENVIRONMENT=${deploy_environment}",
    ],
    physical_cd => true,
    wd          => "${app_dir}/current",
    daemon      => "bin/vanity -ip ${ip} -port ${port} -site ${site_name} 2>&1",
  }

  ::twitch_nginx::vhost{ 'vanity':
    content => template('vanity/nginx.conf.erb'),
  }
}
