class vanity::monitoring {
  $check_commands = {
    'load' => {
      command  => 'check_load -r -w 2.55,2.55 -c 2.80,2.80',
      interval => 1,
      options  => {
        use            => 'passive-service',
        contact_groups => 'devtools_pagerduty',
      },
    },
    'memory' => {
      command => 'check_memswap.pl -w 80:50 -c 90:70',
      options => {
        use            => 'passive-service',
        contact_groups => 'devtools_pagerduty',
      },
    },
    'disk space' => {
      command  => 'check_disk -w 30% -c 20% -r /dev/ -C -w 30% -c 20% -p /boot -i /snap',
      interval => 3,
      options  => {
        use            => 'passive-service',
        contact_groups => 'devtools_pagerduty',
      },
    },
    'godoc port 80' => {
      command => 'check_http -H localhost',
      options => {
        use            => 'passive-service',
        contact_groups => 'devtools_pagerduty',
      },
    }
  }
  create_resources(twitch_servicecheck::passive, $check_commands)
}
