# Setup rsyslog for varnishd
class varnish::logging (
) inherits varnish {

  validate_bool($varnishd_syslog_enable)

  $_enable = $varnishd_syslog_enable ? {
    true    => 'present',
    default => 'absent'
  }

  # this template actually has zero dynamic content
  ::rsyslog::snippet { '43-varnishd':
    ensure  => $_enable,
    content => template("${module_name}/43-varnishd.conf.erb")
  }

}
