# class to hold all global or factual options
class varnish::params {
  $varnish_version     = undef # will be selected based on varnish_release but we can override
  $varnish_release     = '4.1'

  # varnish stuff
  $package             = 'varnish'

  $varnish_service     = 'varnish'
  $varnish_default     = '/etc/default/varnish'
  $varnish_enable      = true
  $varnish_notify      = false
  $varnish_dir         = '/etc/varnish'
  $varnish_pid         = '/run/varnishd.pid'
  $varnish_pop         = $::pop

  # varnish_default
  $nfiles              = 131072
  $memlock             = 82000

  # varnish daemon options; used to generate DAEMON_OPTS
  # QUESTION: do we need secret file everywhere, can it be?
  $listen              = undef                   # -a
  $telnet_listen       = '127.0.0.1:6082'        # -T
  # we use this basic file as a default
  $config_file         = undef                   # -f
  # this is passed into the main class if you want to use a template
  $config_template     = undef                   # -f
  $working_dir         = undef                   # -n
  $secret_file         = "${varnish_dir}/secret" # -S
  $backend_storage     = 'malloc,256m'           # -s
  $shared_memory       = undef                   # -l
  # hash of extra parameters
  $params              = {}                      # -p

  $numa_interleave = false

  # varnishlog
  $varnishlog_service  = 'varnishlog'
  $varnishlog_default  = '/etc/default/varnishlog'
  $varnishlog_uid      = 'varnishlog'
  # Note that the varnish package defaults to the varnish group
  $varnishlog_gid      = 'varnishlog'
  $varnishlog_enable   = false
  $varnishlog_notify   = false
  $varnishlog_pid      = '/run/varnishlog/varnishlog.pid'

  # Redirect syslog message from varnishd (e.g. varnishadm)
  # not to confused with varnishlog or varnishncsa
  $varnishd_syslog_enable = true

  # varnishncsa
  $varnishncsa_service = 'varnishncsa'
  $varnishncsa_default = '/etc/default/varnishncsa'
  $varnishncsa_enable  = false
  $varnishncsa_notify  = false
  $varnishncsa_log     = '/var/log/varnish/varnishncsa.log'
  $varnishncsa_pid     = '/run/varnishncsa/varnishncsa.pid'

  # used as an option in varnishncsa template
  $log_format          = undef
  # used as an option to filter out varnishncsa logs
  $vsl_query           = undef

  # global
  $varnish_log_dir     = '/var/log/varnish'

  # vmods
  $vmod_path           = '/usr/lib/varnish/vmods'
  $vmod_base_path      = dirname($vmod_path)

  # QUESTION: do these get autoloaded/can we put them everywhere without using them in a config
  $default_vmods       = [
    # DEPRECATED: Old timers module. Has a broken req_end, but we keep
    # it around because it can't safely be removed or changed while
    # Varnish is running.
    'libvmod_timers.so',
    # New timers module, from
    # https://git-aws.internal.justin.tv/video/libvmod_timers2.
    'libvmod_timers2.so',
    # https://git-aws.internal.justin.tv/video/libvmod-curl
    'libvmod_curl.so',
    # https://git-aws.internal.justin.tv/video/libvmod-twitchdirectors
    'libvmod_twitchdirectors.so'
  ]

  $segment_ttls = {
    'edge' => '60s',
    'pr' => '40s',
  }

  $upstream_override   = []

  $playlist_longpoll   = false

  # varnish_stats nrdp check
  $varnish_nrdp_args   = '--name /dev/shm/varnish/ --sma-usage-warn 0:0.9 --sma-usage-crit 0:0.95 --nuked-crit 0:0'

  $upstream_reporting = true
}
