class varnish::services inherits varnish {
  service { $varnish_service:
    ensure     => $varnish_enable ? {
      true  => 'running',
      false => 'stopped'
    },
    enable     => $varnish_enable,
    # restart => "/etc/init.d/varnish reload"
    hasrestart => true,
    require    => Package[$package],
    subscribe  => Package[$package],
  }

  service { $varnishlog_service:
    ensure     => $varnishlog_enable ? {
      true  => 'running',
      false => 'stopped'
    },
    enable     => $varnishlog_enable,
    hasrestart => true,
    hasstatus  => false,
    subscribe  => Package[$package],
  }

  service { $varnishncsa_service:
    ensure     => $varnishncsa_enable ? {
      true  => 'running',
      false => 'stopped'
    },
    enable     => $varnishncsa_enable,
    hasrestart => true,
    hasstatus  => false,
    subscribe  => Package[$package],
  }
}
