# a define to easily add vcl files
define varnish::vcl (
  $ensure         = 'present',
  $source         = undef,
  $template       = undef,
  $notify_service = undef,
) {
  # we need the variables local
  include varnish
  $package            = $varnish::package
  $varnish_service    = $varnish::varnish_service
  $varnish_dir        = $varnish::varnish_dir
  $varnish_notify     = $varnish::varnish_notify
  $varnish_release    = $varnish::release
  $varnish_pop        = $varnish::varnish_pop
  $segment_ttls       = $varnish::segment_ttls
  $upstream_override  = $varnish::upstream_override
  $playlist_longpoll  = $varnish::playlist_longpoll
  $upstream_reporting = $varnish::upstream_reporting

  $vcl_file = "${varnish_dir}/${name}"

  include twitch_vars
  $twitch_networks = $::twitch_vars::twitch_networks

  # define file here
  file { $vcl_file:
    ensure => $ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    before => Class['::varnish::install']
  }

  # adjust here
  if ($template) {
    File[$vcl_file] {
      content => template("${module_name}/${varnish_release}/${template}")
    }
  } elsif ($source) {
    File[$vcl_file] {
      source => "puppet:///modules/${module_name}/${varnish_release}/${source}"
    }
  } else {
    # if we haven't specified a 'source' or 'template'
    # lets just look for the name of the file
    File[$vcl_file] {
      source => [
        "puppet:///modules/${module_name}/${varnish_release}/${name}"
      ]
    }
  }

  if ($varnish_notify) {
    File[$vcl_file] {
      notify => Service[$varnish_service]
    }
  }

  if ($notify_service) {
    File[$vcl_file] {
      notify => Service[$notify_service]
    }
  }

}
