# a define to easily add in vmods to varnish
define varnish::vmod (
  $ensure    = 'present',
  $vmod_path = $varnish::params::vmod_path,
  $package   = $varnish::params::package,
) {

  include varnish
  $release   = $varnish::release

  file { "${vmod_path}/${name}":
    ensure  => $ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    require => File[$vmod_path],
    before  => Class['::varnish::install'],
    source  => "puppet:///modules/${module_name}/${release}/vmods/${name}",
  }
}
