node default {

    $varnish_config = 'appcache.vcl'
    $pr_servers  = ['test1.sfo01', 'test2.sfo01']
    $pr_port     = 6081
    $sfo_servers = better_range('hls1', 'hls96')
    $sfo_port    = 80

    class { '::varnish':
        config_file        => $varnish_config,
        listen             => ':6081',
        backend_storage    => 'malloc,6g',
        working_dir        => '/dev/shm/varnish',
        worker_threads     => '100,2000,300',
        varnish_notify     => true,
        varnishncsa_enable => true,
        log_format         => '%h %l %u %t "%r" %s %b "%{Referer}i" "%{User-agent}i" - %{Varnish:time_firstbyte}x %{Varnish:hitmiss}x'
    }

    $vcl_files = {
        'base.vcl'   => {
            template => 'hls/base.vcl.erb'
        },
        'common.vcl' => {
            template => 'hls/common.vcl.erb'
        },
    }

    create_resources(varnish::vcl, $vcl_files)

    include varnish::vmods
}
