require 'erb'
require 'optparse'

$internal_ip = nil
$print_on_render = false
$use_curl_vmod = false
$templates_dir = "../../templates/3.0/hls/"

OptionParser.new do |opts|
	opts.on(:REQUIRED, "--internal-ip=IPv4", "IP to use as an internal one") do |v|
		$internal_ip = v
	end
        opts.on("--templates-dir=PATH", "Path to the templates directory") do |v|
		$templates_dir = v
	end
	opts.on("--print", "print out the templates in addition to saving them") do |v|
		$print_on_render = true
	end
	opts.on("--use-curl-vmod", "use the curl vmod for edge tests") do |v|
		$use_curl_vmod = true
	end
end.parse!

raise OptionParser::MissingArgument.new("internal-ip") if $internal_ip.nil? || $internal_ip.empty?

raise OptionParser::InvalidOption.new("the internal ip has to be in a numeric IPv4 format, not '#{$internal_ip}'") \
	if $internal_ip !~ /^([0-9]+\.){3}[0-9]+$/

class VTemplate
	include ERB::Util

	def initialize(fqdn, out_dir)
		@in_dir = $templates_dir
		@out_dir = out_dir
		@twitch_networks = [ "#{$internal_ip}/32" ]
		@fqdn = fqdn
		@segment_ttls = { "edge" => "60s", "pr" => "40s" }
		@varnish_pop = "fake01"
		@playlist_longpoll = true
	end

	def render
		begin
			Dir.mkdir @out_dir
		rescue Errno::EEXIST
		end
		@files.each do |input, output|
			input = File.join(@in_dir, input)
			output = File.join(@out_dir, output)
			t = ERB.new(IO.read(input), nil, '-')
			t.filename = output
			r = t.result binding
			puts "Generated #{output}:\n#{r}" if $print_on_render
			IO.write(output, r)
		end
	end
end

class T1Template < VTemplate
	def initialize
		super("video-tier1-varnish.fake01.justin.tv", "./video-t1/")
		@files = {
			'common.vcl.erb' => 'common.vcl',
			'base.vcl.erb' => 'base.vcl',
		}
	end
end

T1Template.new.render
