class varnishshmparser (
  $ensure                  = 'present',
  $deploy_environment      = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary                  = false,
  $node_type               = 'edge',
  $varnishshmparser_enable = true,
  $statsd_host             = hiera('statsd_host', 'statsd.internal.justin.tv'),
  $statsd_port             = hiera('statsd_port', '8125'),
  $statsd_sample_rate      = 0.005,
  $varnish_shm_location    = '/dev/shm/varnish',
)
{
  require varnish

  $varnishshmparser_args = join_keys_to_values(delete_undef_values({
    '--datacenter'    => $::pop,
    '--node-type'     => $node_type,
    '--sample-rate'   => $statsd_sample_rate,
    '--n'             => $varnish_shm_location,
    '--statsd-server' => "${statsd_host}:${statsd_port}",
  }), '=')

  $varnishshmparser_cmd = join([
    './varnishshmparser',
    join($varnishshmparser_args, ' ')
  ], ' ')

  validate_bool($varnishshmparser_enable)
  $varnishshmparser_ensure = $varnishshmparser_enable ? {
    true  => 'present',
    false => 'absent',
  }

  twitch::service {'varnishshmparser':
    ensure             => $ensure,
    env                => $deploy_environment,
    canary             => $canary,
    daemon_cmd         => $varnishshmparser_cmd,
    predaemon          => ['mkdir /var/run/varnishshmparser', 'chown varnishshmparser: /var/run/varnishshmparser'],
    service_repo       => 'video/varnishshmparser',
    group              => 'varnish',
    daemontools_ensure => $varnishshmparser_ensure,
    manage_service     => true,
    subscribe          => Package['varnish']
  }
}
