#! /usr/bin/python2.7

import requests
import json
import sys

LVSAPI = "http://lvsapi-external-staging.us-west-2.elasticbeanstalk.com/twirp/lvs.LiveVideoService/CreateStreamKey"
AUTHKEY = "twitch-dev"
SNS = "arn:aws:sns:us-west-2:848744099708:TestLVSStreamNotifications"
BUCKET = "test-lvs-vods"


def get_lvs_stream_key(cid):
    body = {
        "content_id": cid,
        "s3_bucket": BUCKET,
        "sns_notification_endpoint": SNS,
    }

    headers = {
        "X-Twitch-Lvs-Force-Auth": AUTHKEY,
        "Content-Type": "application/json",
        "Accept": "application/json",
    }

    api_resp = requests.post(LVSAPI, data=json.dumps(body), headers=headers)

    skey = json.loads(api_resp.text)
    return skey['streamkey']


def main(argv=None):
    if argv is None:
        argv = sys.argv

    if len(argv) != 2:
        print 'invalid arguments, must specify a single content id'
        return 1

    try:
        print get_lvs_stream_key(argv[1])
    except Exception, e:
        print 'failed to fetch stream key for %s: %s'.format(argv[1], e)
        return 1


if __name__ == '__main__':
    sys.exit(main())

