#!/usr/bin/env python

import requests
import sys
import hmac, hashlib
import calendar, datetime

"""
Command line utility that returns the stream key for test streams. Run this
file with the stream name as the command line argument and the corresponding
stream key will be printed to standard output
"""

def get_stream_key(channel_id):
    """
    Return the stream key (as a string) for 'channel_id'.
    The key is only valid for 5 minutes and only works
    for internal testing channels
    """

    # Generate token base
    secret = "f5590dbf17dde4de16027afa09a5f754cef52bd5"
    timestamp = calendar.timegm(datetime.datetime.utcnow().timetuple())
    base_key = "temp_{id}_{timestamp}".format(id=channel_id, timestamp=timestamp)

    # Generate full key
    sig = hmac.new(secret, base_key, hashlib.sha1).hexdigest()
    streamkey = "{base}_{hash}".format(base=base_key, hash=sig)

    return streamkey


def main(argv=None):
    if argv is None:
        argv = sys.argv

    if len(argv) != 2:
        print 'invalid arguments, must specify a single channel id'
        return 1

    try:
        print get_stream_key(argv[1])
    except Exception, e:
        print 'failed to fetch stream key for %s: %s' % (argv[1], e,)
        return 1

if __name__ == '__main__':
    sys.exit(main())
