import BaseHTTPServer
import SocketServer
import os, syslog
import socket
import thread

class ThreadedHTTPServer(SocketServer.ThreadingMixIn, BaseHTTPServer.HTTPServer):
  def __init__(self, *args):
    BaseHTTPServer.HTTPServer.__init__(self,*args)

  def process_request_thread(self, request, client_address):
    try:
      self.finish_request(request, client_address)
    finally:
      self.close_request(request)

class WowzaUsherHandler(BaseHTTPServer.BaseHTTPRequestHandler):
	sys_log_tag = "wowza_usher_check_handler"
	sys_log_facility = syslog.LOG_LOCAL2
	sys_log_options = 0

	try:
		syslog.openlog(sys_log_tag, sys_log_options,sys_log_facility)
	except:
		print 'failed to open syslog'

	def log_message(self, format, *args):
		syslog.syslog("%s - - [%s] %s\n" % (self.address_string(), self.log_date_time_string(), format%args))

	def do_GET(self):
		result = os.system("wget -O /dev/null -nv -q http://localhost:998/node/publish_enabled && nc -z %s 1935" % os.environ['BOND0_IP'] )
		if result == 0:
			self.send_response(200)
		else:
			self.send_response(404)

if __name__ == '__main__':
  server = ThreadedHTTPServer(('',9393), WowzaUsherHandler)
  server.serve_forever()


