# Define will write configs to the proper directory in JSON
define video::configs (
  $user          = 'jtv',
  $group         = 'jtv',
  $usher_config  = undef,
  $svc_config    = {},
  $use_sandstorm = false
) {
  include video::params

  $real_usher_config = $usher_config ? {
    undef   => $video::params::usher_config,
    default => $usher_config,
  }

  $twitch_basedir = hiera('twitch_basedir','/opt/twitch')
  $app_dir        = "${twitch_basedir}/${name}"
  $conf_dir       = "${app_dir}/etc"
  $config         = merge($real_usher_config,$svc_config)

  validate_hash($config)
  validate_absolute_path($conf_dir)

  courier::dirs{ $name: }

# This does not look to be needed... -MB
#  file{ "${conf_dir}/usher.conf.json":
#    ensure  => present,
#    owner   => $user,
#    group   => $group,
#    mode    => '0644',
#    content => template('video/config.json.erb'),
#  }

  if ($use_sandstorm) {
    twitch_sandstorm_agent::template { "${name}-config":
      owner           => $user,
      group           => $group,
      mode            => '0644',
      destination     => "${conf_dir}/${name}.conf.json",
      restart_command => "sudo svc -t /etc/service/${name}",
      contents        => template('video/config.json.erb'),
      require         => Courier::Dirs[$name],
    }
  } else {
    file{ "${conf_dir}/${name}.conf.json":
      ensure  => present,
      owner   => $user,
      group   => $group,
      mode    => '0644',
      content => template('video/config.json.erb'),
      require => Courier::Dirs[$name],
    }
  }
}
