class video::crons::rotate_varnish_logs_hourly {
  $status = $::fqdn ? {
    /^video/         => 'present',
    default          => 'absent',
  }

  $random_minute = fqdn_rand(59)

  cron::hourly { 'rotate_varnish_logs':
    command => 'ionice -c 3 nice -n19 /usr/sbin/logrotate -f /etc/logrotate.d/varnish',
    user    => 'root',
    minute  => $random_minute,
    ensure  => $status,
  }
  # Delete this after some time.. -jul2016
  cron {'rotate_varnish_logs': user => 'root', ensure => 'absent'}
}
