class video::edge {

  consul::service { 'video-hls-replication':
    port               => 80,
    consul_tags        => concat(["fqdn=${::fqdn}"], [ 'role-edge' ], [ $::twitch_environment ]),
    maintmode_kv_watch => false,
  }

  class { 'twitch_cosmos':
    node_type => 'edge',
    ensure    => 'present',
  }

  class { 'darkseer': }

  class { '::warp': }

  include twitch_nrdp

  class { 'twitch_crashmonitor':
    ensure => 'absent',
  }

  if $::network_drivers =~ /mlx5_core/ {
    class { 'irq_affinity':
      require => Class['twitch_dkms'],
    }

    # TODO: move this to twitch_irqbalance/manifests/params.pp once
    # https://git-aws.internal.justin.tv/systems/puppet/pull/10124 has been merged
    class { 'twitch_irqbalance':
      policyscript => 'irqbalance_policy.sh';
    }
  }

  # AES must be enabled on edges. check for it.
  realize(Twitch_nrdp::Check['check_aes'])
  # Add sandstorm checks to this sandstormified-host.
  realize(Twitch_nrdp::Check['check_sandstorm_agent'])
  realize(Twitch_nrdp::Check['check_sandstorm_agent_ops'])
}
