class video::graceful_drain {
  require varnish

  $secret_file = $varnish::secret_file
  $telnet_listen = $varnish::telnet_listen

  # this file is custom file used for draining varnish
  # on replication servers
  file { '/usr/local/bin/varnish_graceful_drain':
    content => template("${module_name}/graceful_drain.sh.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }

  # this is to ensure we dont have the old version of the above script
  $old_prefix = '/usr/local/bin/varnish_clean'
  $old_files = ["${old_prefix}_stop", "${old_prefix}_restart", "${old_prefix}.sh"]
  file { $old_files:
    ensure => 'absent'
  }
}
