class video (
  $role                      = undef,
  $use_bird                  = $video::params::use_bird,
  $statsd_host               = $video::params::statsd_host,
  $statsd_port               = $video::params::statsd_port,
  $varnish_wd                = $video::params::varnish_wd,
  $log_format                = $video::params::log_format,
  $vsl_query                 = $video::params::vsl_query,
  $edge_viewcount_service    = $video::params::edge_viewcount_service,

  $statsd_sample_rate        = $video::params::statsd_sample_rate,

  $use_varnish               = $video::params::use_varnish,
  $varnish_max_memory        = $video::params::varnish_max_memory,
  $varnish_listen            = $video::params::varnish_listen,
  $varnish_release           = $video::params::varnish_release,
  $varnish_upstream          = $video::params::varnish_upstream,

  $use_artm                  = $video::params::use_artm,
  $artm_ensure               = $video::params::artm_ensure,
  $varnish_config_file       = $video::params::varnish_config_file,
  $varnishncsa_enable        = $video::params::varnishncsa_enable,
  $vcl_files                 = $video::params::vcl_files,
  $consul_tags               = $video::params::consul_tags,
  $consul_env                = $video::params::consul_env,
  $consul_port               = $video::params::consul_port,
  $include_full_services     = $video::params::include_full_services,
  $consul_replication_tree   = $video::params::consul_replication_tree,
  $consul_controlled         = $video::params::consul_controlled,

  $varnish_daemon_params     = $video::params::varnish_daemon_params,
  $varnish_upstream_override = $video::params::varnish_upstream_override,
  $varnish_shared_memory     = $video::params::varnish_shared_memory,
  $weaver_hostname           = $video::params::weaver_hostname,
  $weaver_log_retain         = $video::params::weaver_log_retain,
  $weaver_haproxy_maxconns   = $video::params::weaver_haproxy_maxconns,
) inherits video::params {
  # TODO delete these crons
  include video::crons::max_nic_updater
  include video::shared_reqs

  validate_string($varnish_config_file)
  validate_numeric($statsd_sample_rate)
  validate_re($varnish_max_memory, '^\d+[gGmM]$')
  validate_re($varnish_shared_memory, '^\d+[mM](,\d+[mM]){0,2}$', "the \$varnish_shared_memory parameter must have 1, 2 or 3 comma separated values, got '$varnish_shared_memory' instead")
  validate_bool($varnishncsa_enable)
  validate_bool($use_bird)
  validate_bool($use_varnish)
  validate_hash($vcl_files)
  validate_hash($varnish_daemon_params)
  validate_integer($consul_port)
  validate_string($role)
  validate_bool($consul_replication_tree)
  validate_bool($consul_controlled)

  Package <| title == 'snmp' |> {
    ensure => absent,
  }

  class { 'courierd':
    version => absent,
  }

  class { 'twitch_barrel': }

  # Don't include the listeners if the backend is actually disabled.
  # This should be done in the actual listeners but that's a lot of work.
  if $twitch::haproxy::backend::ensure == 'present' {
    class { 'twitch::haproxy::listeners::backend_video_api_http': }
  }

  consul::service { 'video-hls-replication':
    port               => $consul_port,
    consul_tags        => concat(["fqdn=${::fqdn}"], $consul_tags, $consul_env),
    maintmode_kv_watch => $consul_controlled,
  }

  # disabling artm is only allowed for non-production use of this module
  if ($use_artm) {
    if $consul_replication_tree {
      $artm_node_ttl        = '120s'
      $artm_update_interval = '20s'
    } else {
      $artm_node_ttl        = undef
      $artm_update_interval = undef
    }
    # Set up ARTM
    class { '::artm':
      ensure          => $artm_ensure,
      varnish_name    => $varnish_wd,
      update_interval => $artm_update_interval,
      node_ttl        => $artm_node_ttl,
      require         => Class['::varnish'],
    }
  }

  # TODO: VIDCS-2715 - cleanup after completion of xenial migration to bionic
  # Separate conditional to maintain existing behavior on xenial
  if $use_varnish {
    class { 'video::crons::rotate_varnish_logs_hourly': }

    $varnish_daemon_params_merged = merge({
      'timeout_idle'        => 60,
      'send_timeout'        => 60,
      'idle_send_timeout'   => 60,
      'thread_pool_min'     => 100,
      'thread_pool_max'     => 2000,
      'thread_pool_timeout' => 300,
      'cli_timeout'         => 60,
    }, $varnish_daemon_params)

    class { '::varnish':
      release            => $varnish_release,
      listen             => $varnish_listen,
      working_dir        => $varnish_wd,
      log_format         => $log_format,
      vsl_query          => $vsl_query,
      config_file        => $varnish_config_file,
      varnishncsa_enable => $varnishncsa_enable,
      backend_storage    => "malloc,${varnish_max_memory}",
      shared_memory      => $varnish_shared_memory,
      params             => $varnish_daemon_params_merged,
      upstream_override  => $varnish_upstream_override,
    }

    $rotate_retain = $::fqdn ? {
      /^video-weaver/  => $weaver_log_retain,
      default          => 48,
    }

    logrotate::rule{ 'varnish':
      ensure          => present,
      path            => '/var/log/varnish/varnish*.log',
      missingok       => true,
      rotate          => $rotate_retain,
      rotate_every    => 'day',
      sharedscripts   => true,
      compress        => true,
      delaycompress   => false,
      compresscmd     => '/bin/bash',
      compressoptions => '-c "dd iflag=direct bs=128k status=none | gzip -1 | dd bs=128k oflag=direct status=none"',
      compressext     => '.gz',
      create          => true,
      create_mode     => '0644',
      create_owner    => 'varnishlog',
      postrotate      => join([
        'for service in varnishlog varnishncsa; do',
        '      if /usr/bin/pgrep -P 1 $service >/dev/null; then',
        '        /usr/sbin/invoke-rc.d $service reload > /dev/null',
        '      fi',
        '    done' ],"\n")
    }

    if ($use_artm) {
      $extra_vcl_properties = { notify_service => 'artm' }
    } else {
      $extra_vcl_properties = {}
    }

    create_resources(varnish::vcl, $vcl_files, $extra_vcl_properties)

    # intent here is to make '/etc/init.d/varnish reload' fail and take no action
    file { '/usr/share/varnish/reload-vcl':
      mode    => '0644',
      require => Class['::varnish'],
    }

    class { 'libvmod_twitchdirectors': }
  }
}
